-- Copyright 1994 Altera Corporation
-- VHDL example for use with System 1164
-- Description : 4 bit up counter with asynchronous reset
-- 				 and synchronous load
--

Library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity count4 is
        port(clock, reset, enable, load : in std_logic := '0';
             data: in std_logic_vector (3 downto 0) := "0000";
             qout: out std_logic_vector (3 downto 0)
			);
end count4;

architecture maxplus of count4 is
    constant ONE : std_logic_vector(0 downto 0) := "1";
    signal count : std_logic_vector(3 downto 0) ;
begin

   CNT: process(clock, reset)
   begin
      	if reset = '1' then
         	count <= "0000";
      	elsif ( clock' event and clock = '1') then
			if load = '1' then
				count <= data;
			else
           		count <= count + ONE;
			end if;
        end if;

    end process CNT;
	
	TRI: process(enable, count)
	begin
		if(enable = '1') then
			qout <= count;
		end if;
	end process TRI;
end MAXPLUS;

